/* PROGRAM FOR SIZE: NEWEDF */

new;

/* SAMPLE SIZE AND MAXIMUM LAG NUMBER */

N=100;
Pmax=10;

load ECV[8*Pmax,6]=myout\edf\newedf\newedf.ecv;

/* Empirical Power at 10%, 5% and 1% levels */

ECV=ECV[.,3:4]~ECV[.,6];


INDEXP=zeros(Pmax,1);
INDEX1=ones(Pmax,1);
j=1;
do until j==Pmax+1;
INDEXP[j,1]=j;
j=j+1;
endo;

/* 1: ACV OF GCV TEST */

GCVacv=(0.0066520694*index1)~(0.0077699373*index1)~(0.010673058*index1);

/* 2: ACV OF THE CV TEST */

CVacv=(0.34730*index1)~(0.46136*index1)~(0.74346*index1);

/* 3: ACV OF THE GKS TEST */

GKSacv=(0.44146782*index1)~(0.47120202*index1)~(0.53129267*index1);

/* 4: ACV OF THE KS TEST */

KSacv=(1.22*index1)~(1.36*index1)~(1.62*index1);

/* 5: ASYMPTOTIC CRITICAL VALUES OF DEGALDO */

load Dacv[15,4]=myout\ecf\Degaldo.acv;
Dacv=Dacv[1:Pmax,2:4];

/* 6: ACV OF HONG-JRSSB TEST */

Hacv=(1.28155155*index1)~(1.64485363*index1)~(2.32634786*index1);

/* 7: ASYMPTOTIC CRITICAL VALUES OF SKAUG AND TJOSTHEIM */

load STacv[20,4]=myout\edfstacv;
STacv=STacv[1:Pmax,2:4];

ACV=GCVacv|CVacv|GKSacv|KSacv|Dacv|Hacv|STacv|STacv;

/* SEED NUMBERS */

iseed1=2555130;
iseed2=2578452;

/* WEIGHT FOR NEW GCV AND GKS TESTS */

/* GCV: WEIGHTING */

Wgcv=zeros(n-1,1);

j=1;
do until j==n;
Wgcv[j,1]=(n-j)/(j*pi)^2;
j=j+1;
endo;

/* ANDERSON'S CV WEIGHTING */

/* WEIGHTING */

Wcv=zeros(n-1,1);
j=1;
do until j==n;
Wcv[j,1]=n/(j*pi)^2;
j=j+1;
endo;

/* HONG'S NEW GKS TEST */

/* Grid Points for Frequencies */

N2=100;

V=zeros(1,N2);
j=1;
do until j==N2+1;
V[1,j]=j/N2;
j=j+1;
endo;

Wgks=zeros(N-1,N2);
j=1;
do until j==N;
Wgks[j,.]=sqrt(N-j)*sqrt(2)*sin(j*pi*V)/(j*pi);
j=j+1;
endo;


/* ANDERSON'S KS TEST */

/* Grid Points for Frequencies */

N2=100;

V=zeros(N2,1);
j=1;
do until j==N2+1;
V[j,1]=j/N2;
j=j+1;
endo;

j=1;
Wks=zeros(N2,N-1);
do until j==N;
Wks[.,j]=sqrt(N)*sqrt(2)*sin(j*pi*V)/(j*pi);
j=j+1;
endo;


/* HONG'S JRSSB TEST */

/* KERNEL FUNCTIONS */

/* DANIELL KERNEL */

PROC Wdan(u);
LOCAL Y;
Y=sin(pi*u)./(pi*u);
RETP(Y);
ENDP;

Kdan=zeros(N-1,Pmax);

p=1;
do until p==Pmax+1;
j=1;
do until j==N;
Kdan[j,p]=Wdan(j/(p+1));
j=j+1;
endo;
p=p+1;
endo;

/* NOTE: CK and DK are row 1 by Pmax vectors */

K=Kdan;
K2=K^2;
CK=sumc(K2);
CK=CK';
K4=K2[1:N-2,.]^2;
DK=sumc(K4);
DK=DK';

/* WEIGHTING FOR SKAUG AND TJOSTHEIM TEST */

/* ORIGINAL FORM */

W1st=zeros(Pmax,Pmax);
p=1;
do until p==Pmax+1;
j=1;
do until j==p+1;
W1st[j,p]=(N-1);
j=j+1;
endo;
p=p+1;
endo;

/* ALTERNATIVE FORM OF SKAUG-TJOSTHEIM */

W2st=zeros(Pmax,Pmax);
p=1;
do until p==Pmax+1;
j=1;
do until j==p+1;
W2st[j,p]=N-j;
j=j+1;
endo;
p=p+1;
endo;

/* NOW ONLY 5 ALTERNATIVES */

ALTER=13;
do until ALTER==13+1;

/* ITERATION NUMBERS */

ITR=1;
Imax=1000;
do until ITR==Imax+1;

/* NORMAL RANDOM SAMPLE OF SIZE N */

if ALTER==1;

/* AR(1): COEE=0.3 */

ARPHA=0.3;

e=rndns(N+100,1,iseed1);

X=zeros(N+100,1);
X[1,1]=e[1,1];
j=2;
do until j==N+100+1;
X[j,1]=ARPHA*X[j-1,1]+e[j,1];
j=j+1;
endo;
X=X[101:N+100,1];

elseif ALTER==2;

/* N0 IS INITIAL OBSERVATIONS */

ARPHA=0.3;

N0=156+1;
NN0=N+N0;

AUTO=zeros(NN0,1);
AUTO[1,1]=1;
i=2;
do until i==NN0+1;
AUTO[i,1]=AUTO[i-1,1]*((i-1)-1+ARPHA)/((i-1)-ARPHA);
i=i+1;
endo;

/* COMPUTING REAL FOURIER */

RAUTO=rev(AUTO);
GA=AUTO|RAUTO[2:(NN0-1),1];
GA=(2*NN0-2)*FFT(GA);
GA=REAL(GA);
i=1;
do until i==2*NN0-2+1;
if GA[i,1] < 0;
GA[i,1]=0;
endif;
i=i+1;
endo;

G05=sqrt(GA);

u0=rndns(NN0,2,iseed1);

u01=u0[.,1];
u02=u0[.,2];

u01[1,1]  =sqrt(2)*u01[1,1];
u01[NN0,1]=sqrt(2)*u01[NN0,1];
u02[1,1]=0.0;
u02[NN0,1]=0.0;
ru01=rev(u01);
ru02=rev(u02);

Zu1=COMPLEX(u01[1:NN0,1], u02[1:NN0,1]);
Zu2=COMPLEX(ru01[2:(NN0-1),1], -ru02[2:(NN0-1),1]);
Zu=Zu1|Zu2;
GZ=G05.*Zu;
X=sqrt(NN0-1)*CFFT(GZ);
X=REAL(X);
X=X[1:NN0,1];

X=X[N0+1:NN0,1];

elseif ALTER==3;

/* BL */

ARPHA=0.8;

e=rndns(N+100,1,iseed1);

X=zeros(N+100,1);
X[1,1]=e[1,1];
X[2,1]=e[2,1];
j=3;
do until j==N+100+1;
X[j,1]=ARPHA*e[j-1,1]*X[j-2,1]+e[j,1];
j=j+1;
endo;

X=X[101:N+100,1];


elseif ALTER==4;

/* TAR(1) */

ARPHA=0.4;

e=rndns(N+100,1,iseed1);

X=zeros(N+100,1);
X[1,1]=e[1,1];
j=2;
do until j==N+100+1;
X[j,1]=-0.5*X[j-1,1]*(X[j-1,1]<=1)+ARPHA*X[j-1,1]*(X[j-1,1]>1)+e[j,1];
j=j+1;
endo;

X=X[101:N+100,1];

elseif ALTER==5;

/* NMA */

ARPHA=0.8;

e=rndns(N+100,1,iseed1);

X=zeros(N+100,1);
X[1,1]=e[1,1];
X[2,1]=e[2,1];
j=3;
do until j==N+100+1;
X[j,1]=ARPHA*e[j-1,1]*e[j-2,1]+e[j,1];
j=j+1;
endo;

X=X[101:N+100,1];

elseif ALTER==6;

/* EXTENDED NMA(20) */

ARPHA=0.8;
e=rndns(N+100,1,iseed1);

X=zeros(N+100,1);

X[1,1]=e[1,1];
X[2,1]=e[2,1];

t=3;
do until t==N+100+1;

X[t,1]=e[t,1];

if t <= 20;
Jtmax=t-1;
else;
Jtmax=20;
endif;

j=2;
do until j==Jtmax+1;
X[t,1]=X[t,1]+ARPHA^(j-1)*e[t-1,1]*e[t-j,1];
j=j+1;
endo;

t=t+1;
endo;

X=X[101:100+N,1];

elseif ALTER==7;

/* BILINEAR BL TYPE II */

ARPHA=0.5;
e=rndns(N+100,1,iseed1);

X=zeros(N+100,1);

X[1,1]=e[1,1];
t=2;
do until t==N+100+1;
X[t,1]=(0.2+ARPHA*e[t-1,1])*X[t-1,1]+e[t,1];
t=t+1;
endo;

X=X[101:100+N,1];

elseif ALTER==8;

/* NONLINEAR MA TYPE II */

ARPHA=0.8;
e=rndns(N+100,1,iseed1);

X=zeros(N+100,1);

X[1,1]=0;
t=2;
do until t==N+100+1;
X[t,1]=e[t-1,1]*(ARPHA+e[t,1]);
t=t+1;
endo;

X=X[101:100+N,1];

elseif ALTER==9;

/* EXP(1) */

ARPHA=0.5;

e=rndns(N+100,1,iseed1);

X=zeros(N+100,1);
X[1,1]=e[1,1];
j=2;
do until j==N+100+1;
X[j,1]=ARPHA*X[j-1,1]*exp(-0.5*X[j-1,1]*X[j-1,1])+e[j,1];
j=j+1;
endo;

X=X[101:N+100,1];

elseif ALTER==10;

/* EXP(10) */

ARPHA=0.2;
e=rndns(N+100,1,iseed1);

X=zeros(N+100,1);
X[1,1]=e[1,1];
t=2;
do until t==N+100+1;
if t<=10;
Jtmax=t-1;
else;
Jtmax=10;
endif;

X[t,1]=e[t,1];
j=1;
do until j==Jtmax+1;
X[t,1]=X[t,1]+ARPHA*X[t-j,1]*exp(-0.5*X[t-j,1]*X[t-j,1]);
j=j+1;
endo;

t=t+1;
endo;

X=X[101:100+N,1];

elseif ALTER==11;

/* GARCH(1,1) */

ARPHA=0.59;

e=rndns(N+100,1,iseed1);

X=zeros(N+100,1);
CH=X;
CH[1,1]=1;
X[1,1]=e[1,1]*sqrt(CH[1,1]);
j=2;
do until j==N+100+1;
CH[j,1]=1+0.4*X[j-1,1]*X[j-1,1]+ARPHA*CH[j-1,1];
X[j,1]=e[j,1]*sqrt(CH[j,1]);
j=j+1;
endo;

X=X[101:N+100,1];

elseif ALTER==12;

/* ARCH(1) */

ARPHA=0.8;

e=rndns(N+100,1,iseed1);

X=zeros(N+100,1);
CH=X;
CH[1,1]=1;
X[1,1]=e[1,1]*sqrt(CH[1,1]);
j=2;
do until j==N+100+1;
CH[j,1]=1+ARPHA*X[j-1,1]*X[j-1,1];
X[j,1]=e[j,1]*sqrt(CH[j,1]);
j=j+1;
endo;

X=X[101:N+100,1];

elseif ALTER==13;

/* AR(1): COEE=0.2 */

ARPHA=0.2;

e=rndns(N+100,1,iseed1);

X=zeros(N+100,1);
X[1,1]=e[1,1];
j=2;
do until j==N+100+1;
X[j,1]=ARPHA*X[j-1,1]+e[j,1];
j=j+1;
endo;
X=X[101:N+100,1];

endif;

/* SUBVECTORS */

/* t=j+1 to N */

PROC X1(j);
LOCAL Y;
Y=X[j+1:N,1];
RETP(Y);
ENDP;

/* t=1 to N-j */

PROC X2(j);
LOCAL Y;
Y=X[1:N-j,1];
RETP(Y);
ENDP;

/* HONG'S NEW GCV TEST */

/* COMPUTE HONG'S MEASURE */

PROC F1(u,j);
LOCAL Y;
Y=(u'-X1(j).>=0);
Y=meanc(Y); /* This sums over X1(j) */
RETP(Y);
ENDP;

PROC F2(v,j);
LOCAL Y;
Y=(v'-X2(j).>=0);
Y=meanc(Y); /* This sums over X2(j) */
RETP(Y);
ENDP;

PROC F(u,v,j);
LOCAL Y;
Y=(u-X1(j)'.>=0)*(v'-X2(j).>=0);
RETP(Y/(N-j)); /* This sums over j */
ENDP;

/* HONG'S MEASURE */

PROC S1(j);
LOCAL Y;
Y=F(X,X,j)-F1(X,j)*F2(X,j)';
Y=meanc(meanc(Y.*Y));
RETP(Y);
ENDP;

S1cvm=zeros(n-1,1);
j=1;
do until j==N;
S1cvm[j,1]=S1(j);
j=j+1;
endo;

GCV=Wgcv'S1cvm;

/* ANDERSON'S CV TEST */

Xm=meanc(X);
COV0=(X-Xm)'(X-Xm);

PROC COV(j);
LOCAL Y;
Y=(X1(j)-Xm)'(X2(j)-Xm);
RETP(Y);
ENDP;

Corr=zeros(n-1,1);
j=1;
do until j==N;
Corr[j,1]=COV(j);
j=j+1;
endo;

Corr=Corr./COV0;
CV=Corr.*Corr;

CV=Wcv'CV;

/* HONG'S GKS TEST */

j=1;
do until j==N;

/* Sj is a N^2 by 1 vector */

Sj=vec(F(X,X,j)-F1(X,j)*F2(X,j)');

/* Y is a N^2 x N2 matrix */

if j==1;
Y=Sj*Wgks[j,.];
else;
Y=Y+Sj*Wgks[j,.];
endif;
j=j+1;
endo;

/* THIS IS GKS STATISTIC */

Y=abs(Y);

GKS=maxc(maxc(Y));

/* ANDERSON'S KS TEST */

KS=abs(Wks*Corr);
KS=maxc(KS);

GCV=GCV*index1;
CV=CV*index1;
GKS=GKS*index1;
KS=KS*index1;

/* DELGADO TEST */

/* XP is a N-p x 1 vector */

PROC XP(j,p);
RETP(X[j:N-p+j-1,1]);
ENDP;

PROC DEGAL(p);
LOCAL Y1,Y2,Y,j;
j=1;
do until j==p+2;
Y=XP(j,p);
Y=(Y-Y'.<=0);
if j==1;
Y1=Y;
Y2=meanc(Y);
else;
Y1=Y1.*Y;
Y2=Y2.*meanc(Y);
endif;
j=j+1;
endo;
Y=meanc(Y1)-Y2;
Y=Y'Y;
RETP(Y);
ENDP;

DSTAT=zeros(1,Pmax);
p=1;
do until p==Pmax+1;
DSTAT[1,p]=DEGAL(p);
p=p+1;
endo;

/* HONG'S JRSSB TEST */

/* JOINT EDF */

/* COMPUTE HOEFFDING MEASURE */

PROC HMj(j);
LOCAL Y1,Y2,Y;
Y1=(X1(j)-X1(j)'.<=0);
Y2=(X2(j)-X2(j)'.<=0);
Y=meanc(Y1.*Y2)-meanc(Y1).*meanc(Y2);
RETP(Y'Y/(n-j));
ENDP;

HM=zeros(1,N-1);
STM=HM;
j=1;
do until j==N;
STM[1,j]=HMj(j);
HM[1,j]=(N-j)*STM[1,j];
j=j+1;
endo;

/* Hstat is a 1 by Pmax vector */

Hstat=90*(HM*K2-CK/36)./sqrt(2*Dk);

/* SKAUG AND TJSOTHEIM 1993 BIOMETRIKA TEST */

/* THIS is a 1 by Pmax vector */

ST1=STM[1,1:Pmax]*W1st;
ST2=STM[1,1:Pmax]*W2st;

STAT1=GCV|CV|GKS|KS;
STAT2=Dstat~Hstat~ST1~ST2;
STAT2=STAT2';
STAT=STAT1|STAT2;
STAT=STAT~STAT~STAT;

If ITR==1;
REJ=(STAT-ECV.>0);
else;
REJ=REJ+(STAT-ECV.>0);
endif;

N~ALTER~ITR;

ITR=ITR+1;
endo;

REJ=REJ/Imax;

/*
INDEXL is index for p
INDEXH is index for which tests
*/

i=1;
do until i==8+1;
if i==1;
INDEXL=INDEXP;
INDEXH=i*index1;
INDEXA=ALTER*index1;
else;
INDEXL=INDEXL|INDEXP;
INDEXH=INDEXH|(i*index1);
INDEXA=INDEXA|(ALTER*index1);
endif;
i=i+1;
endo;

output file=myout\edf\newedf\newedf.p on;
INDEXA~INDEXH~INDEXL~REJ;
output off;

ALTER=ALTER+1;
endo;
